/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.datasource.URISplit;
import org.das2.util.StringSchemeEditor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AutoRangeHintsStringSchemeEditor
extends JPanel
implements StringSchemeEditor {
    private ButtonGroup buttonGroup1;
    private JCheckBox centerCB;
    private JTextField centerTextField;
    private JCheckBox extendByPercentCB;
    private JTextField extendByPercentTF;
    private JCheckBox includeZeroCB;
    private JLabel jLabel1;
    private JCheckBox logCB;
    private JRadioButton logFalseRB;
    private JRadioButton logTrueRB;
    private JCheckBox maxValueCB;
    private JTextField maxValueTF;
    private JCheckBox minValueCB;
    private JTextField minValueTF;
    private JCheckBox widthCheckBox;
    private JTextField widthTextField;
    private JCheckBox widthsCheckBox;
    private JTextField widthsTextField;
    private BindingGroup bindingGroup;

    public AutoRangeHintsStringSchemeEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.includeZeroCB = new JCheckBox();
        this.widthCheckBox = new JCheckBox();
        this.widthTextField = new JTextField();
        this.widthsCheckBox = new JCheckBox();
        this.widthsTextField = new JTextField();
        this.logCB = new JCheckBox();
        this.logTrueRB = new JRadioButton();
        this.logFalseRB = new JRadioButton();
        this.centerCB = new JCheckBox();
        this.centerTextField = new JTextField();
        this.minValueCB = new JCheckBox();
        this.minValueTF = new JTextField();
        this.maxValueCB = new JCheckBox();
        this.maxValueTF = new JTextField();
        this.extendByPercentCB = new JCheckBox();
        this.extendByPercentTF = new JTextField();
        this.jLabel1.setText("Auto Range Hints");
        this.includeZeroCB.setText("Ensure that zero is within range");
        this.widthCheckBox.setText("Constrain the axis range to a particular width");
        this.widthTextField.setText("10");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.widthCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.widthTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.widthsCheckBox.setText("Constrain the axis range to a set of widths");
        this.widthsTextField.setText("10,300,10000");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.widthsCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.widthsTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.logCB.setText("Force log or linear");
        this.buttonGroup1.add(this.logTrueRB);
        this.logTrueRB.setText("true");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.logCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.logTrueRB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.buttonGroup1.add(this.logFalseRB);
        this.logFalseRB.setText("false");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.logCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.logFalseRB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.centerCB.setText("Center the axis at this value");
        this.centerTextField.setText("0");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.centerCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.centerTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.minValueCB.setText("Min Value");
        this.minValueTF.setText("0");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minValueCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.minValueTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.maxValueCB.setText("Max Value");
        this.maxValueTF.setText("100");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.maxValueCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.maxValueTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.extendByPercentCB.setText("Extend by Percent");
        this.extendByPercentTF.setText("10");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.extendByPercentCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.extendByPercentTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthTextField, -2, 131, -2).addComponent(this.widthsTextField, -2, 345, -2).addGroup(layout.createSequentialGroup().addComponent(this.logTrueRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logFalseRB)).addGroup(layout.createSequentialGroup().addComponent(this.minValueTF, -2, 124, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.minValueCB).addGap(96, 96, 96).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.maxValueTF, -2, 155, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.maxValueCB).addContainerGap(266, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.extendByPercentCB).addComponent(this.includeZeroCB).addComponent(this.logCB).addComponent(this.widthCheckBox).addComponent(this.widthsCheckBox).addComponent(this.centerCB).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.centerTextField, -1, 116, Short.MAX_VALUE).addComponent(this.extendByPercentTF, -2, 123, -2)))).addGap(0, 0, Short.MAX_VALUE)))))));
        layout.linkSize(0, this.centerTextField, this.widthTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.includeZeroCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.widthCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widthTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.widthsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widthsTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.logCB).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logTrueRB).addComponent(this.logFalseRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minValueCB).addComponent(this.maxValueCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minValueTF, -2, -1, -2).addComponent(this.maxValueTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.extendByPercentCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extendByPercentTF, -2, -1, -2).addContainerGap(89, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    public void setValue(String v) {
        LinkedHashMap params = URISplit.parseParams((String)v);
        if (params.containsKey("includeZero")) {
            this.includeZeroCB.setSelected(((String)params.get("includeZero")).toUpperCase().startsWith("T"));
        }
        if (params.containsKey("width")) {
            this.widthCheckBox.setSelected(true);
            this.widthTextField.setText((String)params.get("width"));
        } else {
            this.widthCheckBox.setSelected(false);
        }
        if (params.containsKey("widths")) {
            this.widthsCheckBox.setSelected(true);
            this.widthsTextField.setText((String)params.get("widths"));
        } else {
            this.widthsCheckBox.setSelected(false);
        }
        if (params.containsKey("log")) {
            this.logCB.setSelected(true);
            this.logTrueRB.setSelected(((String)params.get("log")).toUpperCase().startsWith("T"));
        } else {
            this.logCB.setSelected(false);
        }
        if (params.containsKey("center")) {
            this.centerCB.setSelected(true);
            this.centerTextField.setText((String)params.get("center"));
        } else {
            this.centerCB.setSelected(false);
        }
        if (params.containsKey("min")) {
            this.minValueCB.setSelected(true);
            this.minValueTF.setText((String)params.get("min"));
        }
        if (params.containsKey("max")) {
            this.maxValueCB.setSelected(true);
            this.maxValueTF.setText((String)params.get("max"));
        }
        if (params.containsKey("extend")) {
            this.extendByPercentCB.setSelected(true);
            this.extendByPercentTF.setText((String)params.get("extend"));
        }
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        if (this.includeZeroCB.isSelected()) {
            b.append("&includeZero=T");
        }
        if (this.widthCheckBox.isSelected()) {
            b.append("&width=").append(this.widthTextField.getText().trim());
        }
        if (this.widthsCheckBox.isSelected()) {
            b.append("&widths=").append(this.widthsTextField.getText().trim());
        }
        if (this.logCB.isSelected()) {
            b.append("&log=").append(this.logTrueRB.isSelected() ? "T" : "F");
        }
        if (this.centerCB.isSelected()) {
            b.append("&center=").append(this.centerTextField.getText().trim());
        }
        if (this.minValueCB.isSelected()) {
            b.append("&min=").append(this.minValueTF.getText().trim());
        }
        if (this.maxValueCB.isSelected()) {
            b.append("&max=").append(this.maxValueTF.getText().trim());
        }
        if (this.extendByPercentCB.isSelected()) {
            b.append("&extend=").append(this.extendByPercentTF.getText().trim());
        }
        return b.length() == 0 ? "" : b.substring(1);
    }

    public Component getComponent() {
        return this;
    }

    public void setContext(Object o) {
    }

    public String getLabel() {
        return "Autorange Hints Editor";
    }
}

